% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_read_bullet.R
\name{jpinfect_read_bullet}
\alias{jpinfect_read_bullet}
\title{Import one week or more weeks of bullet reports}
\usage{
jpinfect_read_bullet(
  year = NULL,
  week = 1:53,
  directory,
  language = "en",
  output_file = NULL
)
}
\arguments{
\item{year}{An integer specifying the year of the data files to process. If NULL, all years available in the directory are processed.}

\item{week}{A numeric vector specifying the weeks to process (default is 1:53).}

\item{directory}{A string specifying the directory containing the JIHS data files (required).}

\item{language}{A character string specifying the language of the data ('en' for English, 'jp' for Japanese). Default is 'en'.}

\item{output_file}{A string specifying the file name to save the combined data. If NULL, the combined data is not saved (default is NULL).}
}
\value{
A data frame containing the combined and processed JIHS surveillance data.
        If `output_file` is specified, the data is also saved to a CSV file in the specified directory.
}
\description{
This function imports and processes surveillance data files downloaded from the Japan Institute for Health Security (JIHS).
The processed data for the specified year and weeks is combined into a single data frame, optionally saved to a file.
}
\details{
- The function reads all files matching the specified `year` and `language` in the given `directory`.
- Files are filtered based on their naming patterns, which include `_zensu_en.csv` for English and `_zensu_jp.csv` for Japanese.
- Each file is read and processed, including renaming columns, adding `year` and `week` information, and rearranging columns.
- If no files matching the criteria are found, the function raises an error.
- Processed data for all specified files is combined into a single data frame.
}
\examples{
\donttest{
# Process data for 2025, weeks 1 to 10, in English, and save the output
combined_data <- jpinfect_read_bullet(year = 2025, week = 1:10,
                                         directory = "raw_data", language = "en",
                                         output_file = "processed_2025.csv")

# Process Japanese data for all available years in the directory
combined_data <- jpinfect_read_bullet(directory = "raw_data", language = "jp")

# Process data for 2023, weeks 5 to 15, without saving the output
combined_data <- jpinfect_read_bullet(year = 2023, week = 5:15,
                                         directory = "raw_data", language = "en")
}

}
