% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_scale.R
\name{ir_scale}
\alias{ir_scale}
\title{Scales spectra in an \code{ir} object}
\usage{
ir_scale(x, center = TRUE, scale = TRUE, return_ir_flat = FALSE)
}
\arguments{
\item{x}{An object of class \code{ir}, where all non-empty spectra have identical
wavenumber values.}

\item{center}{either a logical value or numeric-alike vector of length
    equal to the number of columns of \code{x}, where
    \sQuote{numeric-alike} means that \code{\link[base]{as.numeric}(.)} will
    be applied successfully if \code{\link[base]{is.numeric}(.)} is not true.}

\item{scale}{either a logical value or a numeric-alike vector of length
    equal to the number of columns of \code{x}.}

\item{return_ir_flat}{Logical value. If \code{TRUE}, the spectra are returned as
\code{\link[=ir_new_ir_flat]{ir_flat}} object.}
}
\value{
\code{x} where spectra have been scaled, i.e. from each intensity value,
the average across all spectra is subtracted (when \code{center} is a logical
value), or the respective value in \code{center} is subtracted (when \code{center} is
numerical), and each intensity value is divided by the standard deviation of
the intensity values at this wavenumber across all spectra (when \code{scale} is a
logical value), or the respective value in \code{scale} (when \code{scale} is
numerical). \code{NA}s are omitted during this process.
}
\description{
Scales spectra in an \code{ir} object
}
\examples{
ir_sample_data |>
 ir_scale() |>
 plot()

}
