% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSquadIterationAverages.R
\name{getSquadIterationAverages}
\alias{getSquadIterationAverages}
\title{Return a dataframe that contains all squads averages for a given iteration ID}
\usage{
getSquadIterationAverages(iteration, token, host = "https://api.impect.com")
}
\arguments{
\item{iteration}{'IMPECT' iteration ID}

\item{token}{bearer token}

\item{host}{host environment}
}
\value{
a dataframe containing the KPI averages aggregated per squad for the
given iteration ID
}
\description{
Return a dataframe that contains all squads averages for a given iteration ID
}
\examples{
# Toy example: this will error quickly (no API token)
try(squad_avgs <- getSquadIterationAverages(
  iteration = 0,
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
squad_avgs <- getSquadIterationAverages(
  iteration = 1004,
  token = "yourToken"
)
}
}
