% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fix_flowdir}
\alias{fix_flowdir}
\title{Fix Flow Direction}
\usage{
fix_flowdir(id, network = NULL, fn_list = NULL)
}
\arguments{
\item{id}{integer The id of the flowline to check}

\item{network}{data.frame network compatible with \link{hydroloom_names}.}

\item{fn_list}{list containing named elements \code{flowline}, \code{network}, and \code{check_end},
where \code{flowline} is the flowline to be checked and \code{network} the feature up or downstream
of the flowline to be checked, and \code{check_end} is \code{"start"} or \code{"end"} depending if the
\code{network} input is upstream (\code{"start"}) or downstream (\code{"end"}) of the flowline to be checked.
This option allows pre-compilation of pairs of features which may be useful for very large
numbers of flow direction checks.}
}
\value{
a geometry for the feature that has been reversed if needed.
}
\description{
If flowlines aren't digitized in the expected direction,
this will reorder the nodes so they are.
}
\examples{

x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

# We add a tocomid with prepare_nhdplus
x <- add_toids(hy(x))

# Look at the end node of the 10th line.
(n1 <- get_node(x[10, ], position = "end"))

# Break the geometry by reversing it.
sf::st_geometry(x)[10] <- sf::st_reverse(sf::st_geometry(x)[10])

# Note that the end node is different now.
(n2 <- get_node(x[10, ], position = "end"))

# Pass the broken geometry to fix_flowdir with the network for toCOMID
sf::st_geometry(x)[10] <- fix_flowdir(x$id[10], x)

# Note that the geometry is now in the right order.
(n3 <- get_node(x[10, ], position = "end"))

plot(sf::st_geometry(x)[10])
plot(n1, add = TRUE)
plot(n2, add = TRUE, col = "blue")
plot(n3, add = TRUE, cex = 2, col = "red")

}
