% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pathlength.R
\name{add_pathlength}
\alias{add_pathlength}
\alias{add_pathlength.data.frame}
\alias{add_pathlength.hy}
\title{Add Path Length}
\usage{
add_pathlength(x)

\method{add_pathlength}{data.frame}(x)

\method{add_pathlength}{hy}(x)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}
}
\value{
data.frame containing pathlength_km
}
\description{
Generates the main path length to a basin's terminal path.

Requires id, toid, and length_km hydroloom compatible attributes.
}
\examples{
x <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

x <- add_toids(x)

x <- add_pathlength(x)

plot(x["Pathlength"])

}
