% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_statistics.R
\name{plot.hstats_matrix}
\alias{plot.hstats_matrix}
\title{Plots "hstats_matrix" Object}
\usage{
\method{plot}{hstats_matrix}(
  x,
  top_m = 15L,
  fill = getOption("hstats.fill"),
  swap_dim = FALSE,
  viridis_args = getOption("hstats.viridis_args"),
  facet_scales = "fixed",
  ncol = 2L,
  rotate_x = FALSE,
  err_type = c("SE", "SD", "No"),
  ...
)
}
\arguments{
\item{x}{An object of class "hstats_matrix".}

\item{top_m}{How many rows should be plotted? \code{Inf} for all.}

\item{fill}{Fill color of ungrouped bars. The default equals the global option
\code{hstats.fill = "#fca50a"}. To change the global option, use
\verb{options(stats.fill = new value)}.}

\item{swap_dim}{Switches the role of grouping and facetting (default is \code{FALSE}).}

\item{viridis_args}{List of viridis color scale arguments, see
\verb{[ggplot2::scale_color_viridis_d()]}.
The default points to the global option \code{hstats.viridis_args},
which corresponds to \code{list(begin = 0.2, end = 0.8, option = "B")}.
E.g., to switch to a standard viridis scale, you can change the default via
\code{options(hstats.viridis_args = list())}, or set \code{viridis_args = list()}.}

\item{facet_scales}{Value passed as \code{scales} argument to \verb{[ggplot2::facet_wrap()]}.}

\item{ncol}{Passed to \verb{[ggplot2::facet_wrap()]}.}

\item{rotate_x}{Should x axis labels be rotated by 45 degrees?}

\item{err_type}{The error type to show, by default "SE" (standard errors). Set to
"SD" for standard deviations (SE * sqrt(m_rep)), or "No" for no bars.
Currently, supported only for \code{\link[=perm_importance]{perm_importance()}}.}

\item{...}{Passed to \code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}}.}
}
\value{
An object of class "ggplot".
}
\description{
Plot method for objects of class "hstats_matrix".
}
