% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_metrics.R
\name{hb_metrics}
\alias{hb_metrics}
\title{Legacy function to calculate borrowing metrics}
\usage{
hb_metrics(borrow, pool, independent)
}
\arguments{
\item{borrow}{A data frame returned by \code{\link[=hb_summary]{hb_summary()}}
for the mixture or hierarchical model.}

\item{pool}{A data frame returned by \code{\link[=hb_summary]{hb_summary()}}
for the pooled model.}

\item{independent}{A data frame returned by \code{\link[=hb_summary]{hb_summary()}}
for the independent model.}
}
\value{
A data frame with borrowing metrics.
}
\description{
Legacy function to calculate
historical borrowing metrics using
summary output from a fitted borrowing model and
analogous summaries from the benchmark models.
We recommend \code{\link[=hb_ess]{hb_ess()}} instead of \code{\link[=hb_metrics]{hb_metrics()}}.
See the methods vignette in the package for details.
}
\examples{
if (!identical(Sys.getenv("HB_TEST", unset = ""), "")) {
data <- hb_sim_independent(n_continuous = 2)$data
mcmc_borrow <- hb_mcmc_hierarchical(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 100,
  n_iterations = 200
)
mcmc_pool <- hb_mcmc_pool(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 50,
  n_iterations = 50
)
mcmc_independent <- hb_mcmc_independent(
  data,
  n_chains = 1,
  n_adapt = 100,
  n_warmup = 50,
  n_iterations = 50
)
borrow <- hb_summary(mcmc_borrow, data)
pool <- hb_summary(mcmc_pool, data)
independent <- hb_summary(mcmc_independent, data)
hb_metrics(
  borrow = borrow,
  pool = pool,
  independent = independent
)
}
}
\keyword{internal}
