% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_dummy.R
\name{make_dummy}
\alias{make_dummy}
\alias{make_dummy_extract}
\alias{make_dummy_extract.character}
\alias{make_dummy_extract.factor}
\alias{make_dummy_extract.logical}
\alias{make_dummy_extract.default}
\title{Make Dummy Variables}
\usage{
make_dummy(data)

make_dummy_extract(col, name)

\method{make_dummy_extract}{character}(col, name)

\method{make_dummy_extract}{factor}(col, name)

\method{make_dummy_extract}{logical}(col, name)

\method{make_dummy_extract}{default}(col, name)
}
\arguments{
\item{data}{The data frame from which dummy variables need to be extracted.}

\item{col}{A vector to extract dummy variables.}

\item{name}{The vector's name.}
}
\value{
The data frame with extracted dummy variables.
}
\description{
Function \code{make_dummy}
converts categorical variables in a data frame to dummy variables.

Function \code{make_dummy_extract}
converts a column to dummy variables if necessary
and assign appropriate names.
See the "detail" section for further information.
Users can define their own functions to allow the model
deal with some types of variables properly.
}
\details{
If \code{col} is a character vector,
the function will get unique values of its elements
and leave out the last one.
Then, all the unique values are combined with the \code{name} argument
as names of new columns.

If \code{col} is a factor vector,
the function will get its levels and leave out the last one.
Then, all level labels are combined with the \code{name} argument
as names of new columns.

If \code{col} is a logical vector,
the function will convert it to a numeric vector
with value \code{TRUE} mapped to \code{1} and \code{FALSE} to \code{0}.

If \code{col} is of other types,
the default behaviour for extracting dummy variables is
just to copy the original value and try to convert it to numeric values.
}
\examples{
make_dummy(iris["Species"])

make_dummy_extract(iris$Species, "Species")

make_dummy_extract(c("top", "mid", "low", "mid", "top"), "level")

make_dummy_extract(factor(c("far", "near", "near")), "distance")

make_dummy_extract(c(TRUE, TRUE, FALSE), "sold")

}
