% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heplots-internal.R
\name{heplots-internal}
\alias{heplots-internal}
\alias{lambda.crit}
\alias{HLT.crit}
\alias{Roy.crit}
\alias{he.rep}
\alias{termInfo}
\alias{last}
\alias{Pillai}
\alias{Wilks}
\alias{HL}
\alias{Roy}
\title{Internal heplots functions}
\usage{
lambda.crit(
  alpha,
  p,
  dfh,
  dfe,
  test.statistic = c("Roy", "HLT", "Hotelling-Lawley")
)

Roy.crit(alpha, p, dfh, dfe)

HLT.crit(alpha, p, dfh, dfe)

he.rep(x, n)

Pillai(eig, q, df.res)

Wilks(eig, q, df.res)

HL(eig, q, df.res)

Roy(eig, q, df.res)
}
\arguments{
\item{alpha}{significance level for critical values of multivariate
statistics}

\item{p}{Number of variables}

\item{dfh}{degrees of freedom for hypothesis}

\item{dfe}{degrees of freedom for error}

\item{test.statistic}{Test statistic used for the multivariate test}

\item{x}{An argument to \code{\link{heplot}} or \code{\link{heplot3d}} that
is to be repeated for Error and all hypothesis terms}

\item{n}{Number of hypothesis terms}
}
\value{
The critical value of the test statistic
}
\description{
Internal functions for the heplots package
}
\details{
These functions calculate critical values of multivariate test statistics (Wilks' Lambda, Hotelling-Lawley
trace, Roy's maximum root test) used in setting the size of H ellipses relative to E.
They are not intended to be called by the user.
}
\author{
Michael Friendly \email{friendly@yorku.ca}
}
\keyword{internal}
