// (c) The HDF Group
#ifndef H5VLpublic_H
#define H5VLpublic_H
#include "H5public.h"
#include "H5Ipublic.h"
#define H5VL_VERSION 3
#define H5_VOL_INVALID (-1)
#define H5_VOL_NATIVE 0
#define H5_VOL_RESERVED 256
#define H5_VOL_MAX 65535
#define H5VL_CAP_FLAG_NONE 0x0000000000000000
#define H5VL_CAP_FLAG_THREADSAFE 0x0000000000000001
#define H5VL_CAP_FLAG_ASYNC 0x0000000000000002
#define H5VL_CAP_FLAG_NATIVE_FILES 0x0000000000000004
#define H5VL_CAP_FLAG_ATTR_BASIC 0x0000000000000008
#define H5VL_CAP_FLAG_ATTR_MORE 0x0000000000000010
#define H5VL_CAP_FLAG_DATASET_BASIC 0x0000000000000020
#define H5VL_CAP_FLAG_DATASET_MORE 0x0000000000000040
#define H5VL_CAP_FLAG_FILE_BASIC 0x0000000000000080
#define H5VL_CAP_FLAG_FILE_MORE 0x0000000000000100
#define H5VL_CAP_FLAG_GROUP_BASIC 0x0000000000000200
#define H5VL_CAP_FLAG_GROUP_MORE 0x0000000000000400
#define H5VL_CAP_FLAG_LINK_BASIC 0x0000000000000800
#define H5VL_CAP_FLAG_LINK_MORE 0x0000000000001000
#define H5VL_CAP_FLAG_MAP_BASIC 0x0000000000002000
#define H5VL_CAP_FLAG_MAP_MORE 0x0000000000004000
#define H5VL_CAP_FLAG_OBJECT_BASIC 0x0000000000008000
#define H5VL_CAP_FLAG_OBJECT_MORE 0x0000000000010000
#define H5VL_CAP_FLAG_REF_BASIC 0x0000000000020000
#define H5VL_CAP_FLAG_REF_MORE 0x0000000000040000
#define H5VL_CAP_FLAG_OBJ_REF 0x0000000000080000
#define H5VL_CAP_FLAG_REG_REF 0x0000000000100000
#define H5VL_CAP_FLAG_ATTR_REF 0x0000000000200000
#define H5VL_CAP_FLAG_STORED_DATATYPES 0x0000000000400000
#define H5VL_CAP_FLAG_CREATION_ORDER 0x0000000000800000
#define H5VL_CAP_FLAG_ITERATE 0x0000000001000000
#define H5VL_CAP_FLAG_STORAGE_SIZE 0x0000000002000000
#define H5VL_CAP_FLAG_BY_IDX 0x0000000004000000
#define H5VL_CAP_FLAG_GET_PLIST 0x0000000008000000
#define H5VL_CAP_FLAG_FLUSH_REFRESH 0x0000000010000000
#define H5VL_CAP_FLAG_EXTERNAL_LINKS 0x0000000020000000
#define H5VL_CAP_FLAG_HARD_LINKS 0x0000000040000000
#define H5VL_CAP_FLAG_SOFT_LINKS 0x0000000080000000
#define H5VL_CAP_FLAG_UD_LINKS 0x0000000100000000
#define H5VL_CAP_FLAG_TRACK_TIMES 0x0000000200000000
#define H5VL_CAP_FLAG_MOUNT 0x0000000400000000
#define H5VL_CAP_FLAG_FILTERS 0x0000000800000000
#define H5VL_CAP_FLAG_FILL_VALUES 0x0000001000000000
#define H5VL_OPT_QUERY_SUPPORTED 0x0001
#define H5VL_OPT_QUERY_READ_DATA 0x0002
#define H5VL_OPT_QUERY_WRITE_DATA 0x0004
#define H5VL_OPT_QUERY_QUERY_METADATA 0x0008
#define H5VL_OPT_QUERY_MODIFY_METADATA 0x0010
#define H5VL_OPT_QUERY_COLLECTIVE 0x0020
#define H5VL_OPT_QUERY_NO_ASYNC 0x0040
#define H5VL_OPT_QUERY_MULTI_OBJ 0x0080
//! <!-- [H5VL_class_value_t_snip] -->
typedef int H5VL_class_value_t;
//! <!-- [H5VL_class_value_t_snip] -->
typedef enum H5VL_subclass_t {
    H5VL_SUBCLS_NONE,
    H5VL_SUBCLS_INFO,
    H5VL_SUBCLS_WRAP,
    H5VL_SUBCLS_ATTR,
    H5VL_SUBCLS_DATASET,
    H5VL_SUBCLS_DATATYPE,
    H5VL_SUBCLS_FILE,
    H5VL_SUBCLS_GROUP,
    H5VL_SUBCLS_LINK,
    H5VL_SUBCLS_OBJECT,
    H5VL_SUBCLS_REQUEST,
    H5VL_SUBCLS_BLOB,
    H5VL_SUBCLS_TOKEN
} H5VL_subclass_t;
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5VLregister_connector_by_name(const char *connector_name, hid_t vipl_id);
H5_DLL hid_t H5VLregister_connector_by_value(H5VL_class_value_t connector_value, hid_t vipl_id);
H5_DLL htri_t H5VLis_connector_registered_by_name(const char *name);
H5_DLL htri_t H5VLis_connector_registered_by_value(H5VL_class_value_t connector_value);
H5_DLL hid_t H5VLget_connector_id(hid_t obj_id);
H5_DLL hid_t H5VLget_connector_id_by_name(const char *name);
H5_DLL hid_t H5VLget_connector_id_by_value(H5VL_class_value_t connector_value);
H5_DLL ssize_t H5VLget_connector_name(hid_t id, char *name, size_t size);
H5_DLL herr_t H5VLclose(hid_t connector_id);
H5_DLL herr_t H5VLunregister_connector(hid_t connector_id);
H5_DLL herr_t H5VLquery_optional(hid_t obj_id, H5VL_subclass_t subcls, int opt_type, uint64_t *flags);
H5_DLL herr_t H5VLobject_is_native(hid_t obj_id, hbool_t *is_native);
#ifdef __cplusplus
}
#endif
#endif
