% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_ard_hierarchical.R
\name{tbl_ard_hierarchical}
\alias{tbl_ard_hierarchical}
\title{ARD Hierarchical Table}
\usage{
tbl_ard_hierarchical(
  cards,
  variables,
  by = NULL,
  include = everything(),
  statistic = ~"{n} ({p}\%)",
  label = NULL
)
}
\arguments{
\item{cards}{(\code{card})\cr
An ARD object of class \code{"card"} typically created with \verb{cards::ard_*()} functions.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
character vector or tidy-selector of columns in \code{data} used to create a hierarchy. Hierarchy will be built with
variables in the order given.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
a single column from \code{data}. Summary statistics will be stratified by this variable.
Default is \code{NULL}.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns from the \code{variables} argument for which summary statistics should be returned (on the variable label rows).
Including the last element of \code{variables} has no effect since each level has its own row for this variable.
The default is \code{everything()}.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
used to specify the summary statistics to display for all variables in \code{tbl_hierarchical()}.
The default is \code{everything() ~ "{n} ({p})"}.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
used to override default labels in hierarchical table, e.g. \code{list(AESOC = "System Organ Class")}.
The default for each variable is the column label attribute, \code{attr(., 'label')}.
If no label has been set, the column name is used.}
}
\value{
a gtsummary table of class \code{"tbl_ard_hierarchical"}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
\emph{This is an preview of this function. There will be changes in the coming releases, and changes will not undergo a formal deprecation cycle.}

Constructs tables from nested or hierarchical data  structures (e.g. adverse events).
}
\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ADAE_subset <- cards::ADAE |>
  dplyr::filter(
    AESOC \%in\% unique(cards::ADAE$AESOC)[1:5],
    AETERM \%in\% unique(cards::ADAE$AETERM)[1:5]
  )

# Example 1: Event Rates  --------------------
# First, build the ARD
ard <-
  cards::ard_stack_hierarchical(
    data = ADAE_subset,
    variables = c(AESOC, AETERM),
    by = TRTA,
    denominator = cards::ADSL,
    id = USUBJID
  )

# Second, build table from the ARD
tbl_ard_hierarchical(
  cards = ard,
  variables = c(AESOC, AETERM),
  by = TRTA
)

# Example 2: Event Counts  -------------------
ard <-
  cards::ard_stack_hierarchical_count(
    data = ADAE_subset,
    variables = c(AESOC, AETERM),
    by = TRTA,
    denominator = cards::ADSL
  )

tbl_ard_hierarchical(
  cards = ard,
  variables = c(AESOC, AETERM),
  by = TRTA,
  statistic = ~"{n}"
)
\dontshow{\}) # examplesIf}
}
