% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_glance.R
\name{add_glance}
\alias{add_glance}
\alias{add_glance_table}
\alias{add_glance_source_note}
\title{Add model statistics}
\usage{
add_glance_table(
  x,
  include = everything(),
  label = NULL,
  fmt_fun = list(everything() ~ label_style_sigfig(digits = 3), any_of("p.value") ~
    label_style_pvalue(digits = 1), c(where(is.integer), starts_with("df")) ~
    label_style_number()),
  glance_fun = glance_fun_s3(x$inputs$x)
)

add_glance_source_note(
  x,
  include = everything(),
  label = NULL,
  fmt_fun = list(everything() ~ label_style_sigfig(digits = 3), any_of("p.value") ~
    label_style_pvalue(digits = 1), c(where(is.integer), starts_with("df")) ~
    label_style_number()),
  glance_fun = glance_fun_s3(x$inputs$x),
  text_interpret = c("md", "html"),
  sep1 = " = ",
  sep2 = "; "
)
}
\arguments{
\item{x}{(\code{tbl_regression})\cr
a \code{'tbl_regression'} object}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
names of statistics to include in output. Must be column
names of the tibble returned by \code{broom::glance()} or from the \code{glance_fun}
argument. The include argument
can also be used to specify the order the statistics appear in the table.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
specifies statistic labels, e.g. \code{list(r.squared = "R2", p.value = "P")}}

\item{fmt_fun}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the the functions used to format/round the glance statistics.
The default is to round
the number of observations and degrees of freedom to the nearest integer,
p-values are styled with \code{style_pvalue()} and the remaining statistics
are styled with \code{style_sigfig(x, digits = 3)}}

\item{glance_fun}{(\code{function})\cr
function that returns model statistics. Default is
\code{glance_fun()} (which is \code{broom::glance()} for most model objects).
Custom functions must return a single row tibble.}

\item{text_interpret}{(\code{string})\cr
String indicates whether source note text
will be interpreted with
\code{\link[gt:md]{gt::md()}} or \code{\link[gt:html]{gt::html()}}. Must be \code{"md"} (default) or \code{"html"}.}

\item{sep1}{(\code{string})\cr
Separator between statistic name and statistic.
Default is \code{" = "}, e.g. \code{"R2 = 0.456"}}

\item{sep2}{(\code{string})\cr
Separator between statistics. Default is \code{"; "}}
}
\value{
gtsummary table
}
\description{
Add model statistics returned from \code{broom::glance()}. Statistics can either
be appended to the table (\code{add_glance_table()}), or added as a
table source note (\code{add_glance_source_note()}).
}
\section{Tips}{

When combining \code{add_glance_table()} with \code{tbl_merge()}, the
ordering of the model terms and the glance statistics may become jumbled.
To re-order the rows with glance statistics on bottom, use the script below:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_merge(list(tbl1, tbl2)) |>
  modify_table_body(~.x |> dplyr::arrange(row_type == "glance_statistic"))
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if ((identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) && gtsummary:::is_pkg_installed(c("broom", "broom.helpers"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mod <- lm(age ~ marker + grade, trial) |> tbl_regression()

# Example 1 ----------------------------------
mod |>
  add_glance_table(
    label = list(sigma = "\U03C3"),
    include = c(r.squared, AIC, sigma)
  )

# Example 2 ----------------------------------
mod |>
  add_glance_source_note(
    label = list(sigma = "\U03C3"),
    include = c(r.squared, AIC, sigma)
  )
\dontshow{\}) # examplesIf}
}
