% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate.R
\name{gr_set_param}
\alias{gr_set_param}
\title{Set the value of hydrograph separation parameter}
\usage{
gr_set_param(params, p, value, years = NULL)
}
\arguments{
\item{params}{\code{list} of \code{list}s of hydrograph separation parameters as returned in \code{params} attribute by \code{\link[=gr_separate]{gr_separate()}}  with \code{debug = TRUE}.}

\item{p}{Name of the parameter.}

\item{value}{Numeric value to set.}

\item{years}{Integer vector of years to modify. Defaults to \code{NULL}, which means that all years will be modified.}
}
\value{
\code{list} of \code{list}s — a modified version of \code{params}
}
\description{
The value is set for selected years in parameter list. Such list is returned by \code{\link[=gr_separate]{gr_separate()}}  with \code{debug = TRUE} set.
}
\examples{
library(grwat)

data(spas) # example Spas-Zagorye data is included with grwat package

# Debug mode gives access to additional information
sep = gr_separate(spas, 
                  params = gr_get_params(reg = 'center'), 
                  debug = TRUE)

# Visualize
gr_plot_sep(sep, c(1978, 1989)) 

# actual params used for each year
parlist = attributes(sep)$params

# set the sprecdays parameter for multiple years
parlist = gr_set_param(parlist, sprecdays, 
                       years = c(1978, 1989:1995), 
                       value = 15)

# use the list of parameters for separation
sep_new = gr_separate(spas, params = parlist, debug = TRUE)

# Visualize
gr_plot_sep(sep_new, c(1978, 1989))
}
