% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp_S3.R
\name{na.omit.ppp}
\alias{na.omit.ppp}
\title{Handle Missing \link[spatstat.geom]{marks} in \link[spatstat.geom]{ppp.object}.}
\usage{
\method{na.omit}{ppp}(object, ...)
}
\arguments{
\item{object}{a \link[spatstat.geom]{ppp.object}}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \code{\link[=na.omit.ppp]{na.omit.ppp()}} returns a \link[spatstat.geom]{ppp.object}.
}
\description{
Handle Missing \link[spatstat.geom]{marks} in \link[spatstat.geom]{ppp.object}.
}
\details{
Function \code{\link[=na.omit.ppp]{na.omit.ppp()}} omits missing \link[spatstat.geom]{marks} in a \link[spatstat.geom]{ppp.object}.
}
\note{
tzh suppose missing \verb{$x} and \verb{$y} are
forbidden in \link[spatstat.geom]{ppp.object} anyway.
}
\examples{
library(spatstat.data)
library(spatstat.geom)

npoints(nbfires)
npoints(na.omit.ppp(nbfires))

npoints(amacrine)
npoints(na.omit.ppp(amacrine)) # no missing marks to be removed

nbfires_julian = unstack.ppp(nbfires)$out.julian
suppressWarnings(print.ppp(nbfires_julian))
suppressWarnings(plot.ppp(nbfires_julian))
na.omit.ppp(nbfires_julian)
}
\keyword{internal}
