% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored.R
\name{gamma_censored}
\alias{gamma_censored}
\title{Gamma Censored Distribution}
\usage{
gamma_censored(
  shape,
  rate,
  is_censored,
  censor = "right",
  lower = NULL,
  upper = NULL,
  dim = length(is_censored)
)
}
\arguments{
\item{shape}{Shape parameter of the gamma distribution.}

\item{rate}{Rate parameter of the gamma distribution (reciprocal of scale).}

\item{is_censored}{Logical vector indicating whether each observation is censored.}

\item{censor}{Type of censoring: one of 'right', 'left', 'interval'.}

\item{lower}{Lower bound for interval censoring (optional).}

\item{upper}{Upper bound for interval censoring (optional).}

\item{dim}{Dimension of the data (optional, defaults to length of \code{shape}).}
}
\value{
A greta censored gamma distribution node.
}
\description{
Creates a censored gamma distribution for use with greta.
}
