% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_green_index.R
\name{plot_green_index}
\alias{plot_green_index}
\title{Plot the green index}
\usage{
plot_green_index(
  green_index_data,
  base_map = "CartoDB.DarkMatter",
  colors = c("#F0BB62", "#BFDB38", "#367E18"),
  text_size = 12,
  resolution = 350,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  legend_title = "Green_Index",
  legend_position = "right",
  theme = ggplot2::theme_minimal(),
  line_width = 0.8,
  line_type = "solid",
  interactive = FALSE,
  filename = NULL
)
}
\arguments{
\item{green_index_data}{A data frame containing the calculated green index values for each edge.}

\item{base_map}{Character, base map to use. Default is "CartoDB.DarkMatter".
Other options include "Stamen.Toner", "CartoDB.Positron", "Esri.NatGeoWorldMap",
"MtbMap", "Stamen.TonerLines", and "Stamen.TonerLabels".}

\item{colors}{Character vector, colors for the gradient. Default is c("#F0BB62", "#BFDB38", "#367E18").}

\item{text_size}{Numeric, size of the text in the plot. Default is 12.}

\item{resolution}{Numeric, resolution of the plot. Default is 350.}

\item{title}{Character, title for the plot. Default is NULL.}

\item{xlab}{Character, x-axis label for the plot. Default is NULL.}

\item{ylab}{Character, y-axis label for the plot. Default is NULL.}

\item{legend_title}{Character, legend title for the plot. Default is "Green_Index".}

\item{legend_position}{Character, legend position for the plot. Default is "right".}

\item{theme}{ggplot theme object, theme for the plot. Default is ggplot2::theme_minimal().}

\item{line_width}{Numeric, width of the line for the edges. Default is 0.8.}

\item{line_type}{Character or numeric, type of the line for the edges. Default is "solid".}

\item{interactive}{Logical, whether to return an interactive plot using leaflet. Default is FALSE.}

\item{filename}{Character, filename to save the plot. Supported formats include HTML. Default is NULL (no file saved).}
}
\value{
If \code{interactive = TRUE}, returns a Leaflet map object. If \code{interactive = FALSE}, returns a ggplot object.
If a filename is provided, saves the plot to the specified file.
}
\description{
This function plots the green index for the highway network with extensive customization options.
Users can set various parameters like text size, color palette, resolution, base map, line width, line type, and more.
}
