% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binomial_American_Greeks.R
\name{Binomial_American_Greeks}
\alias{Binomial_American_Greeks}
\title{Computes the Greeks of an American call- or put-option with the Binomial
options pricing model}
\usage{
Binomial_American_Greeks(
  initial_price = 100,
  exercise_price = 100,
  r = 0,
  time_to_maturity = 1,
  volatility = 0.3,
  dividend_yield = 0,
  payoff = "call",
  greek = c("fair_value", "delta", "vega", "theta", "rho", "epsilon", "gamma"),
  steps = 1000,
  eps = 1/1e+05
)
}
\arguments{
\item{initial_price}{\itemize{
\item initial price of the underlying asset.
}}

\item{exercise_price}{\itemize{
\item strike price of the option.
}}

\item{r}{\itemize{
\item risk-free interest rate.
}}

\item{time_to_maturity}{\itemize{
\item time to maturity.
}}

\item{volatility}{\itemize{
\item volatility of the underlying asset.
}}

\item{dividend_yield}{\itemize{
\item dividend yield.
}}

\item{payoff}{\itemize{
\item the payoff function, a string in ("call", "put").
}}

\item{greek}{\itemize{
\item the Greek to be calculated.
}}

\item{steps}{\itemize{
\item the number of integration steps.
}}

\item{eps}{\itemize{
\item the step size for the finite difference method to calculate
theta, vega, rho and epsilon
}}
}
\value{
Named vector containing the values of the Greeks specified in the
parameter \code{greek}.
}
\description{
In contract to European Options, American options can be executed at any time
until the expiration date.
For more details on the definition of Greeks in general see \link{Greeks}.
This functions computes Greeks of American put- and call options in the
binomial option pricing model (see (Hull, 2022)).
}
\examples{
Binomial_American_Greeks(initial_price = 100, exercise_price = 100,
r = 0, time_to_maturity = 1, volatility = 0.3, dividend_yield = 0,
payoff = "call", greek = c("fair_value", "delta", "vega", "theta", "rho",
"epsilon", "gamma"), steps = 20)

}
\references{
Hull, J. C. (2022). Options, futures, and other derivatives (11th Edition). Pearson
}
\seealso{
\link{Greeks_UI} for an interactive visualization
}
