% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_season_stats.R
\name{load_tournament}
\alias{load_tournament}
\title{Load Tournament Data}
\usage{
load_tournament(year, tournament, tour = "pga")
}
\arguments{
\item{year}{Season year (e.g., 2025)}

\item{tournament}{Tournament name (partial match) or event_id}

\item{tour}{Tour name: "pga" (default)}
}
\value{
Tibble with tournament leaderboard
}
\description{
Fetch leaderboard data for a tournament. You can specify either the
event_id or search by tournament name.
}
\examples{
\donttest{
# Load by name (partial match works)
masters <- load_tournament(2025, "Masters")
pga_champ <- load_tournament(2025, "PGA Championship")

# Load by event_id
masters <- load_tournament(2025, "401703504")
}
}
