% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printfunctions.R
\name{summary.mcml}
\alias{summary.mcml}
\title{Summarises an mcml fit output}
\usage{
\method{summary}{mcml}(object, ...)
}
\arguments{
\item{object}{an object of class "`mcml`" as a result of a call to MCML, see \link[glmmrBase]{Model}}

\item{...}{Further arguments passed from other methods}
}
\value{
A list with random effect names and a data frame with random effect mean and credible intervals
}
\description{
Summary method for class "`mcml`"
}
\details{
`print.mcml` tries to replicate the output of other regression functions, such
as `lm` and `lmer` reporting parameters, standard errors, and z- and p- statistics.
The z- and p- statistics should be interpreted cautiously however, as generalised
linear miobjected models can suffer from severe small sample biases where the effective
sample size relates more to the higher levels of clustering than individual observations.

Parameters `b` are the mean function beta parameters, parameters `cov` are the
covariance function parameters in the same order as `$covariance$parameters`, and
parameters `d` are the estimated random effects.
}
