% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{meatHC}
\alias{meatHC}
\alias{meatHC.default}
\alias{meatHC.glmmTMB}
\title{Simple Cluster Based Meat Matrix Estimator}
\usage{
meatHC(x, ...)

\method{meatHC}{default}(x, ...)

\method{meatHC}{glmmTMB}(x, ...)
}
\arguments{
\item{x}{a \code{glmmTMB} object fitted with ML (REML is not supported).}

\item{...}{additional arguments passed to \code{\link[sandwich]{estfun}}, in particular
\code{full}, \code{cluster} and \code{rawnames} arguments.}
}
\value{
A square matrix where each element represents the cross-product of the score vectors
 for the parameters in the model. The rows and columns are named according to the parameter names.
}
\description{
This (simplified) method for a new S3 generic based on \code{\link[sandwich]{meatHC}} computes 
the meat matrix for a fitted \code{glmmTMB} model, which is the cross-product of the cluster-wise 
score vectors (empirical estimating functions) extracted by \code{\link[sandwich]{estfun}}.
}
\note{
This meat matrix is not scaled by the number of clusters.
}
\examples{
m <- glmmTMB(count ~ mined + (1 | spp), data = Salamanders, family = nbinom1)
meatHC(m)
meatHC(m, full = TRUE)
}
