% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-wlength.R
\name{scale_x_wl_continuous}
\alias{scale_x_wl_continuous}
\title{Wavelength x-scale}
\usage{
scale_x_wl_continuous(
  unit.exponent = -9,
  name = w_length_label(unit.exponent = unit.exponent, label.text = label.text,
    axis.symbols = axis.symbols),
  breaks = scales::pretty_breaks(n = 7),
  labels = SI_pl_format(exponent = unit.exponent + 9),
  label.text = axis_labels(append = ifelse(axis.symbols, ",", ""))[["w.length"]],
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE),
  ...
)
}
\arguments{
\item{unit.exponent}{integer}

\item{name}{The name of the scale, used for the axis-label.}

\item{breaks}{The positions of ticks or a function to generate them.}

\item{labels}{The tick labels or a function to generate them from the tick
positions.}

\item{label.text}{character Textual portion of the labels.}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}

\item{...}{other named arguments passed to \code{scale_y_continuous}}
}
\description{
Scale x continuous with defaults suitable for wavelengths in nanometres.
}
\details{
This scale automates the generation of axis labels when the variable
  mapped to the \emph{x} aesthetic contains numeric values for wavelengths
  expressed in nanometres. This is how spectral data are stored in all the
  packages of the R for Photobiology suite, inlcuding the the expected data
  by the \code{autoplot()} methods defined in 'ggspectra'.
}
\note{
This function only alters two default arguments, please, see
documentation for \code{\link[ggplot2]{scale_continuous}}
}
\examples{

ggplot(sun.spct) +
  geom_line() +
  scale_x_wl_continuous()

ggplot(sun.spct) +
  geom_line() +
  scale_x_wl_continuous(unit.exponent = -6)

ggplot(sun.spct) +
  geom_line() +
  scale_x_wl_continuous(label.text = "Longitud de onda,")

autoplot(sun.spct) +
  scale_x_wl_continuous(label.text = "Longitud de onda,",
                        unit.exponent = -6)

}
