% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-brain.R
\name{scale_continous_brain}
\alias{scale_continous_brain}
\alias{scale_x_brain}
\alias{scale_y_brain}
\alias{scale_labs_brain}
\title{Axis and label scales from the ggseg atlases}
\usage{
scale_continous_brain(
  atlas = dk,
  position = "dispersed",
  aesthetics = c("y", "x")
)

scale_x_brain(...)

scale_y_brain(...)

scale_labs_brain(atlas = dk, position = "dispersed", aesthetics = "labs")
}
\arguments{
\item{atlas}{data.frame containing the atlas}

\item{position}{Character of either "dispersed" or "stacked".}

\item{aesthetics}{String vector of which aesthetics to scale "x", "y", or "labs".}

\item{...}{additional arguments to pass to \code{\link{adapt_scales}}}
}
\value{
a scaling function to alter continuous axes labels in ggplot2
}
\description{
The `brain` axis and label scales provides scales for the different atlases in the
package. These add axis labels and tick labels corresponding to the different atlases.
}
\examples{
\dontrun{
scale_x_brain()
scale_y_brain()
scale_labs_brain()
}

}
