% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_geodata.R
\name{check_geodata}
\alias{check_geodata}
\title{Check and Download Geospatial Data from GitHub}
\usage{
check_geodata(files = NULL, overwrite = FALSE, quiet = FALSE, max_retries = 3)
}
\arguments{
\item{files}{Character vector. The names of the data files to download. If `NULL`, all available files will be downloaded.}

\item{overwrite}{Logical. Whether to overwrite existing files in `inst/extdata/`. Default is `FALSE`.}

\item{quiet}{Logical. If `TRUE`, suppresses message outputs when files already exist. Default is `FALSE`.}

\item{max_retries}{Integer. The maximum number of retries if a download fails. Default is `3`.}
}
\value{
A character vector of file paths to the downloaded or existing files.
}
\description{
Checks if the required geospatial data files are present in the package's `inst/extdata` directory. If the files are missing, they are downloaded from a specified GitHub repository. The user can specify which files to download, or download all available files by default.
}
\details{
This function uses the `curl` package to download files, and supports displaying a progress bar during the download process. It is particularly useful for large files or when the default download method (`download.file`) is slow or unreliable.
}
\examples{
\donttest{
# Check for and download all geospatial data from GitHub
file_paths <- check_geodata()

# Check and download specific files
file_paths <- check_geodata(files = c("boundary.rda"))
}
}
