% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/craft-align-dendrogram.R
\name{align_dendro}
\alias{align_dendro}
\title{Plot dendrogram tree}
\usage{
align_dendro(
  mapping = aes(),
  ...,
  distance = "euclidean",
  method = "complete",
  use_missing = "pairwise.complete.obs",
  reorder_dendrogram = FALSE,
  merge_dendrogram = FALSE,
  reorder_group = FALSE,
  k = NULL,
  h = NULL,
  cutree = NULL,
  plot_dendrogram = TRUE,
  plot_cut_height = NULL,
  center = FALSE,
  type = "rectangle",
  root = NULL,
  size = NULL,
  data = NULL,
  active = NULL,
  no_axes = deprecated()
)
}
\arguments{
\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
\code{\link[ggplot2:geom_segment]{geom_segment()}}.}

\item{distance}{A string of distance measure to be used. This must be one of
\code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"} or
\code{"minkowski"}.  Correlation coefficient can be also used, including
\code{"pearson"}, \code{"spearman"} or \code{"kendall"}. In this way, \code{1 - cor} will be used
as the distance. In addition, you can also provide a \code{\link[stats:dist]{dist}}
object directly or a function return a \code{\link[stats:dist]{dist}} object. Use
\code{NULL}, if you don't want to calculate the distance.}

\item{method}{A string of the agglomeration method to be used. This should be
(an unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"},
\code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"} (= WPGMA), \code{"median"} (=
WPGMC) or \code{"centroid"} (= UPGMC). You can also provide a function which
accepts the calculated distance (or the input matrix if \code{distance} is \code{NULL})
and returns a \code{\link[stats:hclust]{hclust}} object. Alternative, you can supply
an object which can be coerced to \code{\link[stats:hclust]{hclust}}.}

\item{use_missing}{An optional character string giving a method for computing
covariances in the presence of missing values. This must be (an abbreviation
of) one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
\code{"na.or.complete"}, or \code{"pairwise.complete.obs"}. Only used when \code{distance}
is a correlation coefficient string.}

\item{reorder_dendrogram}{A single boolean value indicating whether to
reorder the dendrogram based on the means. Alternatively, you can provide a
custom function that accepts an \code{\link[stats:hclust]{hclust}} object and the data
used to generate the tree, returning either an \code{\link[stats:hclust]{hclust}} or
\code{\link[stats:dendrogram]{dendrogram}} object. Default is \code{FALSE}.}

\item{merge_dendrogram}{A single boolean value, indicates whether we should
merge multiple dendrograms, only used when previous groups have been
established. Default: \code{FALSE}.}

\item{reorder_group}{A single boolean value, indicates whether we should do
Hierarchical Clustering between groups, only used when previous groups have
been established. Default: \code{FALSE}.}

\item{k}{An integer scalar indicates the desired number of groups.}

\item{h}{A numeric scalar indicates heights where the tree should be cut.}

\item{cutree}{A function used to cut the \code{\link[stats:hclust]{hclust}} tree. It
should accept four arguments: the \code{\link[stats:hclust]{hclust}} tree object,
\code{distance} (only applicable when \code{method} is a string or a function for
performing hierarchical clustering), \code{k} (the number of clusters), and \code{h}
(the height at which to cut the tree). By default,
\code{\link[stats:cutree]{cutree()}} is used.}

\item{plot_dendrogram}{A boolean value indicates whether plot the dendrogram
tree.}

\item{plot_cut_height}{A boolean value indicates whether plot the cut height.}

\item{center}{A boolean value. if \code{TRUE}, nodes are plotted centered with
respect to all leaves/tips in the branch. Otherwise (default), plot them in
the middle of the direct child nodes.}

\item{type}{A string indicates the plot type, \code{"rectangle"} or \code{"triangle"}.}

\item{root}{A length one string or numeric indicates the root branch.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit()}}. Note that for \code{\link[=circle_layout]{circle_layout()}}, all size values
will be interpreted as relative sizes, as this layout type adjusts based on
the available space in the circular arrangement.}

\item{data}{A matrix-like object. By default, it inherits from the layout
\code{matrix}.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}

\item{no_axes}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please add
\code{\link[ggplot2:theme]{theme()}} directly to the ggplot instead.}
}
\description{
Plot dendrogram tree
}
\section{ggplot2 specification}{

\code{align_dendro} initializes a ggplot \code{data} and \code{mapping}.

The internal \code{ggplot} object will always use a default mapping of
\code{aes(x = .data$x, y = .data$y)}.

The default ggplot data is the \code{node} coordinates with \code{edge} data attached
in \code{\link[=ggalign_attr]{ggalign}} attribute, in addition, a
\code{\link[ggplot2:geom_segment]{geom_segment}} layer with a data frame of the \code{edge}
coordinates will be added when \code{plot_dendrogram = TRUE}.

See \code{\link[=fortify_data_frame.dendrogram]{fortify_data_frame.dendrogram()}} for details.
}

\section{Discrete Axis Alignment}{

It is important to note that we consider rows as observations, meaning
\code{vec_size(data)}/\code{NROW(data)} must match the number of observations along the
axis used for alignment (x-axis for a vertical stack layout, y-axis for a
horizontal stack layout).
}

\examples{
# align_dendro will always add a plot area
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_top() +
    align_dendro()
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_top() +
    align_dendro(k = 3L)

}
