% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{req_cache_getrad}
\alias{req_cache_getrad}
\title{Function to set the cache for a getRad specific httr2 request}
\usage{
req_cache_getrad(
  req,
  use_cache = TRUE,
  max_age = getOption("getRad.max_cache_age_seconds", default = 6 * 60 * 60),
  max_n = getOption("getRad.max_cache_n", default = Inf),
  max_size = getOption("getRad.max_cache_size_bytes", default = 1024 * 1024 * 1024),
  ...
)
}
\arguments{
\item{req}{\code{httr2} request.}

\item{use_cache}{Logical indicating whether to use the cache. Default is
\code{TRUE}. If \code{FALSE} the cache is ignored and the file is fetched anew.
This can also be useful if you want to force a refresh of the cache.}

\item{max_n, max_age, max_size}{Automatically prune the cache by specifying
one or more of:
\itemize{
\item \code{max_age}: to delete files older than this number of seconds.
\item \code{max_n}: to delete files (from oldest to newest) to preserve at
most this many files.
\item \code{max_size}: to delete files (from oldest to newest) to preserve at
most this many bytes.
}

The cache pruning is performed at most once per minute.}

\item{...}{Additional arguments passed to \code{httr2::req_cache()}.}
}
\description{
Function to set the cache for a getRad specific httr2 request
}
\keyword{internal}
