% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/congresso_bib.R
\name{congresso_bib}
\alias{congresso_bib}
\title{Function to prepare metadata of the main conference articles for automatic insertion into scientific articles}
\usage{
congresso_bib(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database in the form of a monograph}

\item{input_tam}{is the length of the dataframe with the main scientifics articles, obtained using package bibliorefer.}
}
\value{
The output of the congresso_bib function is the file with the .bib extension, containing the list of references of conference articles in BibTex format, prepared to be automatically included in the list of references of a scientific article.
}
\description{
The congresso_bib function prepares the metadata of the main conference articles to be automatically included in a scientific article. The congresso_bib function internally calls two support functions. The output of the congresso_bib function is the file with the .bib extension, containing the list of references of conference articles in BibTex format, prepared to be automatically included in the list of references of a scientific article.
}
\examples{

# Example 1 - Concatenated position article

# File of database
file_db <- system.file("extdata","congresso.csv", package = "gerefer")
separator <- ";"

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 7

#Calls the function congresso_bib
congressolister_bibtex <- congresso_bib(input_date, input_tam)
congressolister_bibtex


}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
