% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-plot.R
\name{plot.geos_geometry}
\alias{plot.geos_geometry}
\title{Plot GEOS geometries}
\usage{
\method{plot}{geos_geometry}(
  x,
  ...,
  asp = 1,
  bbox = NULL,
  xlab = "",
  ylab = "",
  rule = "evenodd",
  add = FALSE,
  simplify = 1,
  crop = TRUE
)
}
\arguments{
\item{x}{A \link[=as_geos_geometry]{GEOS geometry vector}}

\item{...}{Passed to plotting functions for features: \code{\link[graphics:points]{graphics::points()}}
for point and multipoint geometries, \code{\link[graphics:lines]{graphics::lines()}} for linestring
and multilinestring geometries, and \code{\link[graphics:polypath]{graphics::polypath()}} for polygon
and multipolygon geometries.}

\item{asp, xlab, ylab}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{bbox}{The limits of the plot as a \code{\link[wk:rct]{rct()}} or compatible object}

\item{rule}{The rule to use for filling polygons (see \code{\link[graphics:polypath]{graphics::polypath()}})}

\item{add}{Should a new plot be created, or should \code{handleable} be added to the
existing plot?}

\item{simplify}{A relative tolerance to use for simplification of
geometries. Use 0 to disable simplification; use a higher number
to make simplification coarser.}

\item{crop}{Use \code{TRUE} to crop the input to the extent of the plot.}
}
\value{
The input, invisibly
}
\description{
Plot GEOS geometries
}
\examples{
plot(as_geos_geometry("LINESTRING (0 0, 1 1)"))
plot(as_geos_geometry("POINT (0.5 0.4)"), add = TRUE)

}
