% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeLSPs.R
\name{makeHillshade}
\alias{makeHillshade}
\title{makeAspect}
\usage{
makeHillshade(
  dtm,
  cellSize = 1,
  sunAzimuth = 315,
  sunAltitude = 45,
  doMD = FALSE,
  writeRaster = FALSE,
  outName,
  device = "cpu"
)
}
\arguments{
\item{dtm}{Input SpatRaster object representing bare earth surface elevations.}

\item{cellSize}{Resolution of raster grid. Default is 1 m.}

\item{sunAzimuth}{Direction of illuminating source as a compass direction. Default is 315-degrees or northwest.}

\item{sunAltitude}{Angle of illuminating source above the horizon from 0-degrees (horizon) to 90-degrees (zenith).
Default is 45-degrees}

\item{doMD}{TRUE or FALSE. Whether or not to generate a multidirectional hillshade. Default is FALSE.}

\item{writeRaster}{TRUE or FALSE. Save output to disk. Default is TRUE.}

\item{outName}{Name of output raster with full file path and extension.}

\item{device}{"cpu" or "cuda". Use "cuda" for GPU computation. Without using the GPU,
implementation will not be significantly faster than using non-tensor-based computation.
Defaults is "cpu".}
}
\description{
Calculate a hillshde from a digital terrain model (DTM) using torch
}
\details{
Calculate a hillshade from a digital terrain model (DTM) using torch. User can specify a
illuminating position using an aspect and altitude. A multidirectiontal hillshade is calculated by averaging
hillshades with different sun positions ((north X 2Xnorthwest X west X southeast)/5.
}
\examples{
\dontrun{
pth <- "OUTPUT PATH"
dtm <- rast(paste0(pth, "dtm.tif"))
hsR <- makeHillshade(dtm,
cellSize=1,
sunAzimuth=315,
sunAltitude=45,
doMD = FALSE,
writeRaster=TRUE,
outName=paste0(pth, "hs.tif"), device="cuda")
}
}
