% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_clusterLabel}
\alias{GC_clusterLabel}
\title{Set or Update Cluster Labels for a GC Chart}
\usage{
GC_clusterLabel(
  GC_chart,
  title = NULL,
  show = TRUE,
  width = "100px",
  cluster = NULL,
  position = "left",
  wrapLabel = TRUE,
  wrapOptions = list(),
  ...
)
}
\arguments{
\item{GC_chart}{A GC chart object.}

\item{title}{Character vector. The title for the cluster label. Default is NULL.}

\item{show}{Logical. Whether to show the cluster label. Default is TRUE.}

\item{width}{Character. The width of the cluster label. Default is "100px".}

\item{cluster}{Numeric or character vector. Clusters in the GC chart to update.
Default is NULL.}

\item{position}{Character. Position of the label, either "left" or "right".
Default is "left".}

\item{wrapLabel}{Logical. Indicates whether the label should be wrapped.
Default is TRUE.}

\item{wrapOptions}{List. Specifies the wrapping options.
Default is an empty List.}

\item{...}{Additional customization arguments for the cluster label,
such as 'fontSize', 'fontStyle', 'fontWeight', 'fontFamily', 'cursor', etc.}
}
\value{
Updated GC chart with new or modified cluster labels.
}
\description{
This function allows you to set or update the labels for specified clusters
within a GC chart. It provides flexibility in terms of the title, visibility,
width, position, and other additional customization options.
}
\examples{
genes_data <- data.frame(
  start = c(10, 90, 130, 170, 210),
  end = c(40, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 2, 2, 2)
)

# Set cluster labels
GC_chart(genes_data, cluster ="cluster", group = "group", height = "200px") \%>\%
GC_clusterLabel(title = unique(genes_data$cluster))

# Set label for a specific cluster
GC_chart(genes_data, cluster ="cluster", group = "group", height = "200px") \%>\%
GC_clusterLabel(title = "Cluster 1", cluster = 1)

# Style labels
GC_chart(genes_data, cluster ="cluster", group = "group", height = "200px") \%>\%
  GC_clusterLabel(
    title = c("Cluster 1", "Cluster 2"),
    width = "100px",
    x = 0,
    y = 0,
    position = "left",
    wrapLabel = TRUE,
    wrapOptions = list(
      dyAdjust = 0,
      lineHeightEms = 1.05,
      lineHeightSquishFactor =  1,
      splitOnHyphen =  TRUE,
      centreVertically = TRUE
     ),
    fontSize = "12px",
    fontStyle = "normal",
    fontWeight = "bold",
    fontFamily = "sans-serif",
    cursor = "default"
  )

}
