% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_set_theme}
\alias{g6_set_theme}
\title{Set the theme for a g6 graph via proxy}
\usage{
g6_set_theme(graph, theme)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{theme}{A character string representing the theme to apply to the graph.
There are 2 internal predefined themes: \code{light} and \code{dark}.
Alternatively, you can pass a custom theme object that conforms to the G6 theme specifications,
according to the documentation at \url{https://g6.antv.antgroup.com/en/manual/theme/custom-theme}.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function sets the theme for an existing g6 graph instance
}
\seealso{
\code{\link[=g6_proxy]{g6_proxy()}}
}
