% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{focus_element}
\alias{focus_element}
\title{Configure Focus Element Behavior}
\usage{
focus_element(
  key = "focus-element",
  animation = list(duration = 500, easing = "ease-in"),
  enable = TRUE,
  ...
)
}
\arguments{
\item{key}{Unique identifier for the behavior, used for subsequent operations
(string, default: "focus-element").}

\item{animation}{Focus animation settings (list, default: list with duration 500ms and easing "ease-in").}

\item{enable}{Whether to enable the focus feature (boolean or JS function, default: TRUE).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/focus-element}.}
}
\value{
A list with the configuration settings for the focus-element behavior.
}
\description{
Creates a configuration object for the focus-element behavior in G6.
This behavior allows focusing on specific elements by automatically adjusting the viewport.
}
\examples{
# Basic configuration
config <- focus_element()

# Custom configuration
config <- focus_element(
  key = "my-focus-behavior",
  animation = list(duration = 1000, easing = "ease-out"),
  enable = JS("(event) => event.targetType === 'node'")
)
}
