% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictMetaLayer.R
\name{PredictMetaLayer}
\alias{PredictMetaLayer}
\title{PredictMetaLayer Class}
\description{
This class implement a predicted meta layer. A \link{PredictMetaLayer} can only exist as unique element of a \link{Training} object.

A predicted meta layer can only contain a \link{PredictData} object.
}
\section{Super class}{
\code{\link[fuseMLR:HashTable]{fuseMLR::HashTable}} -> \code{PredictMetaLayer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PredictMetaLayer-new}{\code{PredictMetaLayer$new()}}
\item \href{#method-PredictMetaLayer-print}{\code{PredictMetaLayer$print()}}
\item \href{#method-PredictMetaLayer-getPredicting}{\code{PredictMetaLayer$getPredicting()}}
\item \href{#method-PredictMetaLayer-getIndIDs}{\code{PredictMetaLayer$getIndIDs()}}
\item \href{#method-PredictMetaLayer-getPredictData}{\code{PredictMetaLayer$getPredictData()}}
\item \href{#method-PredictMetaLayer-openAccess}{\code{PredictMetaLayer$openAccess()}}
\item \href{#method-PredictMetaLayer-closeAccess}{\code{PredictMetaLayer$closeAccess()}}
\item \href{#method-PredictMetaLayer-getAccess}{\code{PredictMetaLayer$getAccess()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="add2HashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-add2HashTable'><code>fuseMLR::HashTable$add2HashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="checkClassExist"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-checkClassExist'><code>fuseMLR::HashTable$checkClassExist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getFromHashTable'><code>fuseMLR::HashTable$getFromHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getHashTable'><code>fuseMLR::HashTable$getHashTable()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getId"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getId'><code>fuseMLR::HashTable$getId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="getKeyClass"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-getKeyClass'><code>fuseMLR::HashTable$getKeyClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="fuseMLR" data-topic="HashTable" data-id="removeFromHashTable"><a href='../../fuseMLR/html/HashTable.html#method-HashTable-removeFromHashTable'><code>fuseMLR::HashTable$removeFromHashTable()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictMetaLayer-new"></a>}}
\if{latex}{\out{\hypertarget{method-PredictMetaLayer-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictMetaLayer$new(id, predicting)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character}\cr}

\item{\code{predicting}}{\code{Predicting}\cr}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictMetaLayer-print"></a>}}
\if{latex}{\out{\hypertarget{method-PredictMetaLayer-print}{}}}
\subsection{Method \code{print()}}{
Printer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictMetaLayer$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{\code{any}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictMetaLayer-getPredicting"></a>}}
\if{latex}{\out{\hypertarget{method-PredictMetaLayer-getPredicting}{}}}
\subsection{Method \code{getPredicting()}}{
Getter of the current predicting object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictMetaLayer$getPredicting()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The current predicting object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictMetaLayer-getIndIDs"></a>}}
\if{latex}{\out{\hypertarget{method-PredictMetaLayer-getIndIDs}{}}}
\subsection{Method \code{getIndIDs()}}{
Getter of IDS from the current layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictMetaLayer$getIndIDs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame} containing individuals IDs values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictMetaLayer-getPredictData"></a>}}
\if{latex}{\out{\hypertarget{method-PredictMetaLayer-getPredictData}{}}}
\subsection{Method \code{getPredictData()}}{
Getter of the predicted data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictMetaLayer$getPredictData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The stored \link{PredictData} object is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictMetaLayer-openAccess"></a>}}
\if{latex}{\out{\hypertarget{method-PredictMetaLayer-openAccess}{}}}
\subsection{Method \code{openAccess()}}{
Open access to the meta layer. A meta learner is only
modifiable if the access is opened.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictMetaLayer$openAccess()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictMetaLayer-closeAccess"></a>}}
\if{latex}{\out{\hypertarget{method-PredictMetaLayer-closeAccess}{}}}
\subsection{Method \code{closeAccess()}}{
Close access to the meta layer to avoid accidental
modification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictMetaLayer$closeAccess()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictMetaLayer-getAccess"></a>}}
\if{latex}{\out{\hypertarget{method-PredictMetaLayer-getAccess}{}}}
\subsection{Method \code{getAccess()}}{
Getter of the current access to the meta layer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictMetaLayer$getAccess()}\if{html}{\out{</div>}}
}

}
}
