% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{pervertexdata.smoothgaussian}
\alias{pervertexdata.smoothgaussian}
\title{Perform Gaussian smoothing}
\usage{
pervertexdata.smoothgaussian(
  spherical_surface,
  data,
  fwhm = 15,
  truncfactor = 3.5
)
}
\arguments{
\item{spherical_surface}{an fs.surface instance representing the spherical version (\code{lh.sphere} or \code{rh.sphere} of the subject).}

\item{data}{numerical vector of per-vertex data for the surface}

\item{fwhm}{double, the full width at half maximum for the Gaussian kernel}

\item{truncfactor}{the factor after how many stddevs to truncate the Gaussian kernel}
}
\value{
the smoothed data
}
\description{
Perform Gaussian smoothing
}
\note{
This function has been adapted from FreeSurfer and it is subject to the FreeSurfer software license.
}
\examples{
\dontrun{
sjd = fsaverage.path();
spherical_surface = subject.surface(sjd, "fsaverage3",
  surface="sphere", hemi="lh");
vdata = subject.morph.native(sjd, "fsaverage3", "thickness", hemi="lh");
vdata_smoothed = pervertexdata.smoothgaussian(spherical_surface,
 vdata, fwhm = 15);
vis.data.on.subject(sjd, "fsaverage3", morph_data_lh = vdata);
vis.data.on.subject(sjd, "fsaverage3", morph_data_lh = vdata_smoothed);
}

}
\keyword{internal}
