% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mghheader.R
\name{mghheader.tkreg2scanner}
\alias{mghheader.tkreg2scanner}
\title{Compute tkreg-RAS to scanner-RAS matrix from basic MGH header fields.}
\usage{
mghheader.tkreg2scanner(header)
}
\arguments{
\item{header}{the MGH header}
}
\value{
4x4 numerical matrix, the transformation matrix
}
\description{
This is also known as the 'tkreg2scanner' matrix. Note that this is a RAS-to-RAS matrix. It is the inverse of the 'scanner2tkreg' matrix, see \code{\link[freesurferformats]{mghheader.scanner2tkreg}}.
}
\examples{
    brain_image = system.file("extdata", "brain.mgz",
                               package = "freesurferformats",
                               mustWork = TRUE);
    vdh = read.fs.mgh(brain_image, with_header = TRUE);
    mghheader.tkreg2scanner(vdh$header);

}
\seealso{
Other header coordinate space: 
\code{\link{mghheader.is.ras.valid}()},
\code{\link{mghheader.ras2vox.tkreg}()},
\code{\link{mghheader.ras2vox}()},
\code{\link{mghheader.scanner2tkreg}()},
\code{\link{mghheader.vox2ras.tkreg}()},
\code{\link{mghheader.vox2ras}()},
\code{\link{read.fs.transform.dat}()},
\code{\link{read.fs.transform.lta}()},
\code{\link{read.fs.transform.xfm}()},
\code{\link{read.fs.transform}()},
\code{\link{sm0to1}()},
\code{\link{sm1to0}()}
}
\concept{header coordinate space}
