% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gifti_writer.R
\name{gifti_writer}
\alias{gifti_writer}
\title{Write data to a gifti file.}
\usage{
gifti_writer(filepath, ...)
}
\arguments{
\item{filepath}{path to the output gifti file}

\item{...}{parameters passed to \code{\link{gifti_xml}}.}
}
\description{
Write data to a gifti file.
}
\examples{
\dontrun{
  outfile = tempfile(fileext = '.gii');
  dataarrays = list(rep(3.1, 3L), matrix(seq(6), nrow=2L));
  gifti_writer(outfile, dataarrays, datatype=c('NIFTI_TYPE_FLOAT32', 'NIFTI_TYPE_INT32'));
}

}
\references{
\url{https://www.nitrc.org/frs/download.php/2871/GIFTI_Surface_Format.pdf}
}
