% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/12_update.R
\name{update.modeler}
\alias{update.modeler}
\title{Update a \code{modeler} object}
\usage{
\method{update}{modeler}(object, method = NULL, track = TRUE, eps = 1e-06, ...)
}
\arguments{
\item{object}{An object of class \code{modeler}.}

\item{method}{A character vector specifying optimization methods.
Check available methods using \code{list_methods()}. Defaults to
the ones in \code{object}.}

\item{track}{Logical. If \code{TRUE}, the function compares the SSE
before and after the update and reports how many groups improved. Useful for
evaluating whether the refit led to better convergence.}

\item{eps}{Numeric. The minimum change in SSE required to consider a fit improved.
Defaults to \code{1e-6}. Smaller values may include numerical noise as improvements.}

\item{...}{Additional parameters for future functionality.}
}
\value{
An object of class \code{modeler}, which is a list containing the following elements:
\describe{
  \item{\code{param}}{Data frame containing optimized parameters and related information.}
  \item{\code{dt}}{Data frame with input data, fitted values, and residuals.}
  \item{\code{metrics}}{Metrics and summary of the models.}
  \item{\code{execution}}{Total execution time for the analysis.}
  \item{\code{response}}{Name of the response variable analyzed.}
  \item{\code{keep}}{Metadata retained based on the \code{keep} argument.}
  \item{\code{fun}}{Name of the curve-fitting function used.}
  \item{\code{parallel}}{List containing parallel execution details (if applicable).}
  \item{\code{fit}}{List of fitted models for each group.}
}
}
\description{
It creates a new fitted object using the parameter values from the current
model as initial values. It can also be used to perform a few additional
iterations of a model that has not converged.
}
\examples{
library(flexFitR)
data(dt_potato)
mo_1 <- dt_potato |>
  modeler(
    x = DAP,
    y = GLI,
    grp = Plot,
    fn = "fn_lin_pl_lin",
    parameters = c(t1 = 10, t2 = 62, t3 = 90, k = 0.32, beta = -0.01),
    subset = 195
  )
plot(mo_1)
mo_2 <- update(mo_1)
plot(mo_2)
}
