% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_light_global_surrogate.R
\name{plot.light_global_surrogate}
\alias{plot.light_global_surrogate}
\title{Plot Global Surrogate Trees}
\usage{
\method{plot}{light_global_surrogate}(x, type = 5, auto_main = TRUE, mfrow = NULL, ...)
}
\arguments{
\item{x}{An object of class "light_global_surrogate".}

\item{type}{Plot type, see help of \code{\link[rpart.plot:rpart.plot]{rpart.plot::rpart.plot()}}. Default is 5.}

\item{auto_main}{Automatic plot titles (only if multiple trees are shown).}

\item{mfrow}{If multiple trees are shown in the same figure:
what value of \code{mfrow} to use in \code{\link[graphics:par]{graphics::par()}}?}

\item{...}{Further arguments passed to \code{\link[rpart.plot:rpart.plot]{rpart.plot::rpart.plot()}}.}
}
\value{
An object of class "ggplot".
}
\description{
Use \code{\link[rpart.plot:rpart.plot]{rpart.plot::rpart.plot()}} to visualize trees fitted by
\code{\link[=light_global_surrogate]{light_global_surrogate()}}.
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
x <- flashlight(model = fit, label = "lm", data = iris)
plot(light_global_surrogate(x))
}
\seealso{
\code{\link[=light_global_surrogate]{light_global_surrogate()}}
}
