% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_center.R
\name{grouped_center}
\alias{grouped_center}
\title{Grouped, weighted mean centering}
\usage{
grouped_center(data, x, w = NULL, by = NULL, ...)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{x}{Variable name in \code{data} to center.}

\item{w}{Optional name of the column in \code{data} with case weights.}

\item{by}{An optional vector of column names in \code{data} used to group the results.}

\item{...}{Additional arguments passed to mean calculation (e.g. \code{na.rm = TRUE}).}
}
\value{
A numeric vector with centered values in column \code{x}.
}
\description{
Centers a numeric variable within optional groups and optional weights.
The order of values is unchanged.
}
\examples{
ir <- data.frame(iris, w = 1)
mean(grouped_center(ir, "Sepal.Width"))
rowsum(grouped_center(ir, "Sepal.Width", by = "Species"), ir$Species)
mean(grouped_center(ir, "Sepal.Width", w = "w"))
rowsum(grouped_center(ir, "Sepal.Width", by = "Species", w = "w"), ir$Species)
}
