% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Overdispersion.R
\name{Overdispersion}
\alias{Overdispersion}
\title{Overdispersion}
\usage{
Overdispersion(object)
}
\arguments{
\item{object}{An object from one of the classes of fitTB,fitBB,fitKB,fitGB,fitMB.}
}
\value{
The output of \code{Overdispersion} gives a single value which is the
overdispersion.
}
\description{
After fitting the distribution using this function we can extract the
overdispersion value. This function works for fitTriBin, fitBetaBin,
fitKumBin, fitGHGBB and fitMcGBB for Binomial Mixture Distributions.
Similarly, Alternate Binomial Distributions also support this function for
fitAddBin,fitBetaCorrBin, fitCOMPBin, fitCorrBin and fitMultiBin.
}
\details{
\strong{Note} : Only objects from classes of above mentioned classes
 can be used.
}
\examples{
No.D.D=0:7      #assigning the random variables
Obs.fre.1=c(47,54,43,40,40,41,39,95)  #assigning the corresponding frequencies

#estimating mode value for given data
results<-EstMLETriBin(No.D.D,Obs.fre.1)
results
mode<-results$mode

#fitting the Triangular Bionomial distribution for estimated parameters
TriBin<-fitTriBin(No.D.D,Obs.fre.1,mode)
TriBin

#extracting the overdispersion
Overdispersion(TriBin)

}
