% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horizFPCA.R
\name{horizFPCA}
\alias{horizFPCA}
\title{Horizontal Functional Principal Component Analysis}
\usage{
horizFPCA(warp_data, no = 3, var_exp = NULL, ci = c(-1, 0, 1), showplot = TRUE)
}
\arguments{
\item{warp_data}{fdawarp object from \link{time_warping} of aligned data}

\item{no}{number of principal components to extract}

\item{var_exp}{compute no based on value percent variance explained (example: 0.95)
will override \code{no}}

\item{ci}{geodesic standard deviations (default = c(-1,0,1))}

\item{showplot}{show plots of principal directions (default = T)}
}
\value{
Returns a hfpca object containing \item{gam_pca}{warping functions principal directions}
\item{psi_pca}{srvf principal directions}
\item{latent}{latent values}
\item{U}{eigenvectors}
\item{vec}{shooting vectors}
\item{mu}{Karcher Mean}
}
\description{
This function calculates vertical functional principal component analysis
on aligned data
}
\examples{
hfpca <- horizFPCA(simu_warp, no = 3)
}
\references{
Tucker, J. D., Wu, W., Srivastava, A.,
Generative Models for Function Data using Phase and Amplitude Separation,
Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}
