% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate_pca.R
\name{multivariate_pca}
\alias{multivariate_pca}
\title{Curve PCA}
\usage{
multivariate_pca(
  align_data,
  no = 3,
  var_exp = NULL,
  ci = c(-1, 0, 1),
  mode = "O",
  showplot = TRUE
)
}
\arguments{
\item{align_data}{fdacurve object from \link{multivariate_karcher_mean} of aligned data}

\item{no}{number of components}

\item{var_exp}{compute no based on value percent variance explained (example: 0.95)
will override \code{no}}

\item{ci}{geodesic standard deviations (default = c(-1,0,1))}

\item{mode}{Open (\code{"O"}) or Closed (\code{"C"}) curves}

\item{showplot}{show plots of principal directions (default = TRUE)}
}
\value{
Returns a curve_pca object containing \item{latent}{singular values}
\item{U}{singular vectors}
\item{coef}{principal coefficients}
\item{pd}{principal directions}
}
\description{
Calculate principal directions of a set of curves
}
\examples{
align_data <- multivariate_karcher_mean(beta[, , 1, 1:2], maxit = 2)
out <- multivariate_pca(align_data)
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
