% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointfPCA.R
\name{jointFPCAh}
\alias{jointFPCAh}
\title{Joint Vertical and Horizontal Functional Principal Component Analysis}
\usage{
jointFPCAh(
  warp_data,
  var_exp = 0.99,
  id = round(length(warp_data$time)/2),
  C = NULL,
  ci = c(-1, 0, 1),
  srvf = TRUE,
  showplot = TRUE
)
}
\arguments{
\item{warp_data}{fdawarp object from \link{time_warping} of aligned data}

\item{var_exp}{compute no based on value percent variance explained (default: 0.99)
will override \code{no}}

\item{id}{integration point for f0 (default = midpoint)}

\item{C}{balance value (default = NULL)}

\item{ci}{geodesic standard deviations (default = c(-1,0,1))}

\item{srvf}{use srvf (default = TRUE)}

\item{showplot}{show plots of principal directions (default = T)}
}
\value{
Returns a list containing \item{q_pca}{srvf principal directions}
\item{f_pca}{f principal directions}
\item{latent}{latent values}
\item{coef}{coefficients}
\item{U}{eigenvectors}
\item{mu_psi}{mean psi function}
\item{mu_g}{mean g function}
\item{id}{point use for f(0)}
\item{C}{optimized phase amplitude ratio}
}
\description{
This function calculates amplitude and phase joint functional principal component
analysis on aligned data using the SRVF framework using MFPCA and h representation
}
\examples{
jfpcah <- jointFPCAh(simu_warp)
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
May 2011. Registration of functional data using fisher-rao metric,
arXiv:1103.3817v2.

Jung, S. L. a. S. (2016). "Combined Analysis of Amplitude and Phase Variations in Functional Data."
arXiv:1603.01775.

Tucker, J. D., Wu, W., Srivastava, A.,
Generative Models for Function Data using Phase and Amplitude Separation,
Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}
