% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_depth.R
\name{curve_depth}
\alias{curve_depth}
\title{Calculates elastic depth for a set of curves}
\usage{
curve_depth(beta, mode = "O", rotated = TRUE, scale = TRUE, parallel = FALSE)
}
\arguments{
\item{beta}{Array of sizes \eqn{n \times T \times N} for \eqn{N} curves
of dimension \eqn{n} evaluated on a grid of \eqn{T} points}

\item{mode}{Open (\code{"O"}) or Closed (\code{"C"}) curves}

\item{rotated}{Include rotation (default = \code{TRUE})}

\item{scale}{scale curves to unit length (default = \code{TRUE})}

\item{parallel}{run computation in parallel (default = \code{TRUE})}
}
\value{
Returns a list containing \item{amp}{amplitude depth}
\item{phase}{phase depth}
}
\description{
This functions calculates the elastic depth between set of curves. If the
curves are describing multidimensional functional data, then
\code{rotated == FALSE} and \code{mode == 'O'}
}
\examples{
data("mpeg7")
# note: use more shapes and iterations, small for speed
out = curve_depth(beta[,,1,1:2])
}
\references{
T. Harris, J. D. Tucker, B. Li, and L. Shand, "Elastic depths for
detecting shape anomalies in functional data," Technometrics,
10.1080/00401706.2020.1811156, 2020.
}
\concept{srvf alignment}
\keyword{depth}
