% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactoring.R
\name{curve2srvf}
\alias{curve2srvf}
\title{Converts a curve to its SRVF representation}
\usage{
curve2srvf(beta, is_derivative = FALSE)
}
\arguments{
\item{beta}{A numeric matrix of size \eqn{L \times M} specifying a curve on
an \eqn{L}-dimensional space observed on an evenly spaced grid of \eqn{[0,
  1]} of length \eqn{M}.}

\item{is_derivative}{A boolean value specifying whether the input \eqn{beta}
is the derivative of the original curve. Defaults to \code{FALSE}.}
}
\value{
A function that takes a numeric vector \eqn{s} of values in \eqn{[0,
  1]} as input and returns the values of the SRVF of the original curve at
\eqn{s}.
}
\description{
Converts a curve to its SRVF representation
}
\examples{
curve2srvf(beta[, , 1, 1])
}
