% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_reframe.R
\name{f_reframe}
\alias{f_reframe}
\title{A faster \code{reframe()} with per-group optimisations}
\usage{
f_reframe(.data, ..., .by = NULL, .order = group_by_order_default(.data))
}
\arguments{
\item{.data}{A data frame.}

\item{...}{Name-value pairs of summary functions. Expressions with
\code{across()} are also accepted.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{.order}{Should the groups be returned in sorted order?
If \code{FALSE}, this will return the groups in order of first appearance,
and in many cases is faster.}
}
\value{
A data frame of specified results.
}
\description{
A faster \code{reframe()} with per-group optimisations
}
\section{Details}{


fastplyr data-masking functions like \code{f_mutate} and \code{f_summarise} operate
very similarly to their dplyr counterparts but with some crucial
differences.
Optimisations for by-group operations kick in for
common statistical functions which are detailed below.
A message will be printed which one can disable
by running \code{options(fastplyr.inform = FALSE)}.
When this happens, the expressions which become optimised no longer
obey data-masking rules pertaining to sequential and dependent expression
execution.
For example,
the pseudo code
\code{f_summarise(data, mean = mean(x), mean2 = round(mean), .by = g)}
when optimised will not work because the named col \code{mean} will not be visible
in later expressions.

One can disable fastplyr optimisations
globally by running \code{options(fastplyr.optimise = F)}.
\subsection{Optimised statistical functions}{

Some functions are internally optimised using 'collapse'
fast statistical functions. This makes execution on many groups very fast.

For fast quantiles (percentiles) by group, see \link{tidy_quantiles}

List of currently optimised functions

\code{dplyr::n} -> <custom_expression> \cr
\code{dplyr::row_number} -> <custom_expression> (only for \code{f_mutate}) \cr
\code{dplyr::cur_group} -> <custom_expression> \cr
\code{dplyr::cur_group_id} -> <custom_expression> \cr
\code{dplyr::cur_group_rows} -> <custom_expression> (only for \code{f_mutate}) \cr
\code{dplyr::lag} -> <custom_expression> (only for \code{f_mutate}) \cr
\code{dplyr::lead} -> <custom_expression> (only for \code{f_mutate}) \cr
\code{base::sum} -> \code{collapse::fsum} \cr
\code{base::prod} -> \code{collapse::fprod} \cr
\code{base::min} -> \code{collapse::fmin} \cr
\code{base::max} -> \code{collapse::fmax} \cr
\code{stats::mean} -> \code{collapse::fmean} \cr
\code{stats::median} -> \code{collapse::fmedian} \cr
\code{stats::sd} -> \code{collapse::fsd} \cr
\code{stats::var} -> \code{collapse::fvar} \cr
\code{dplyr::first} -> \code{collapse::ffirst} \cr
\code{dplyr::last} -> \code{collapse::flast} \cr
\code{dplyr::n_distinct} -> \code{collapse::fndistinct} \cr
}
}

