% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-functions.R
\name{sign_bias_test,fEGarch_fit-method}
\alias{sign_bias_test,fEGarch_fit-method}
\title{Sign Bias Test}
\usage{
\S4method{sign_bias_test}{fEGarch_fit}(object, silent = FALSE, ...)
}
\arguments{
\item{object}{an object \code{"fEGarch_fit"} as returned
by the fitting functions of this package, for example
by \code{\link{fEGarch}}.}

\item{silent}{a logical value reflecting whether or not test results
should be printed in a well-formatted manner to the console.}

\item{...}{currently without use.}
}
\value{
Returns a numeric matrix invisibly.
}
\description{
Apply a sign bias test to check
the standardized residuals of a fitted model
from this package for remaining significant
sign effects.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2002-12-31")
spec <- fEGarch_spec()
model <- fEGarch(spec, rt)
sign_bias_test(model)

}
