% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-deblink.R
\name{deblink_pupil}
\alias{deblink_pupil}
\title{Internal function to remove blink artifacts from pupil data}
\usage{
deblink_pupil(x, prev_op, extend)
}
\arguments{
\item{x}{A data frame containing pupil data with columns \code{time_orig} and
the previous operation's pupil column}

\item{prev_op}{The name of the previous operation's pupil column}

\item{extend}{Either a single number indicating symmetric padding in both
directions, or a vector of length 2 indicating asymmetric padding in the
format \code{c(backward, forward)} in milliseconds. Defaults to \code{50}}
}
\value{
A numeric vector of the same length as the input data with blink
artifacts removed (set to NA)
}
\description{
This function implements blink artifact removal by extending
the duration of detected blinks (missing samples) by a specified number of
milliseconds both forward and backward in time. This helps to remove
deflections in pupil size that occur due to eyelid movements during and
around actual blink periods.

This function is called by the exposed wrapper \code{\link[=deblink]{deblink()}}.
}
\details{
The function works by:
\itemize{
\item Identifying missing samples as blink periods
\item Extending these periods by the specified number of milliseconds
\item Setting all samples within the extended blink periods to NA
\item Preserving all other samples unchanged
}

This implementation is based on the approach described in the pupillometry
package by dr-JT
(\url{https://github.com/dr-JT/pupillometry/blob/main/R/pupil_deblink.R}).
}
\keyword{internal}
