% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gencormat.R
\name{gencorrelationmat}
\alias{gencorrelationmat}
\title{Function that generates a correlation matrix taking as input number of factors for each level, factor or factors that present correlation and rho value or values.
Additionally, a mean matrix is required to check consistency.}
\usage{
gencorrelationmat(mean_matrix, rho, label_list = NULL, withinf, nlfA, nlfB)
}
\arguments{
\item{mean_matrix}{Matrix - cell mean value matrix}

\item{rho}{Vector length 1 or 2, or 2 by 2 matrix - Controls how the correlation and hence de covariance matrix is built. See details.}

\item{label_list}{List length 2 - Names of factor levels}

\item{withinf}{Character- Factor for which measurements are repeated, options are NULL, "fA", "fB" and "both". If NULL (default) independent measurements will be considered.}

\item{nlfA}{Integer - number of levels of factor A}

\item{nlfB}{Integer - number of levels of factor B}
}
\value{
Correlation matrix
}
\description{
May be run independently or internally as part of \code{calculate_mean_matrix}.
}
\details{
For a repeated measures experiment \code{withinf} must be set to "fA", "fB" or "both", depending on which is the 'within' factor.
If \code{rho} is a vector length 1, the within subject correlation will be constant for the factor defined in \code{withinf}. If \code{rho} is a vector
length 2 and \code{withinf} is either "fA" or "fB" a correlation gradient will be created from the first to second value of \code{rho}. If \code{rho} is
a vector length 2 and \code{withinf="both"}, the first element of \code{rho} will be the correlation within factor A, while the second element will
be the correlation within factor B. If \code{rho} is a 2*2 matrix, only possible if \code{withinf="both"}, a correlation gradient will be created
across rows of \code{rho} for each of the factors.
}
\examples{

meanvals <- c(seq(3,9,2),seq(2,8,2),seq(1,7,2))
mean_matrix <- matrix(meanvals, 3, 4, byrow = TRUE,
                   dimnames = list(A=LETTERS[1:3], B=letters[1:4]))

mean_matrix

gencorrelationmat(mean_matrix = mean_matrix, rho = 0.7, withinf = "fB", nlfA = 3, nlfB = 4)

##correlation gradient over levels of factor B
gencorrelationmat(mean_matrix = mean_matrix, rho = c(0.7, 0.4), withinf = "fB", nlfA = 3, nlfB = 4)

##gradient both factors

rhovals <- matrix(c(0.7, 0.4), 2, 2, byrow = TRUE)
gencorrelationmat(mean_matrix = mean_matrix, rho = rhovals, withinf = "both", nlfA = 3, nlfB = 4)

}
