% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accGraph.R
\name{accGraph}
\alias{accGraph}
\title{Create graphics of species discoveries accumulation and nomenclatural changes}
\usage{
accGraph(inputdf = NULL,
         verbose = TRUE,
         spp_acc = TRUE,
         spp_changes = TRUE,
         spp_changes_col = NULL,
         genus_plots = TRUE,
         save = FALSE,
         dir = "results_accGraph",
         filename = "cumulative_discovery_",
         format = "pdf")
}
\arguments{
\item{inputdf}{A dataframe generated using \code{powoSpecies} function using
the argument synonyms set as \code{TRUE} and containing the genus and species
column and the associated information about the protologue of each species.
The species name must be binomial, i.e. must contain both the genus name and
specific epithet.}

\item{verbose}{Logical, if \code{FALSE}, a message showing each step during
the POWO search will not be printed in the console in full.}

\item{spp_acc}{Logical. Setting to \code{FALSE} means that you do not want to
create individual accumulation graphs for each genus present in your dataset.
The default is \code{TRUE}.}

\item{spp_changes}{Logical. Setting to \code{FALSE} means that you do not want
to create a violin plot with all data provided. The default is \code{TRUE}.}

\item{spp_changes_col}{Define the name of a column in the main input data
for which the species changes will be considered. For example, if densities
and jitters should be presented for each genus in the same graphic, then set
\code{spp_changes_col = "genus"}. If you are plotting the dynamics of
nomenclatural changes across the entire dataset in a single density graphic,
then you must add a new column in your input data containing the same character
inside all rows. In this case, ensure that you also keep \code{genus_plots = TRUE}.}

\item{genus_plots}{Logical. If \code{FALSE}, a single density and jitter plot
graphic will be produced for the entire input data. The default is \code{TRUE},
which will result in a graphic where multiple densities and jitters will be
created inside the graphic, depending on the chosen column.}

\item{save}{Logical, if \code{TRUE}, the search results will be saved on disk.}

\item{dir}{Pathway to the computer's directory, where the file will be saved
provided that the argument \code{save} is set up in \code{TRUE}. The default
is to create a directory named \strong{results_accGraph} and the search results
will be saved within a subfolder named after the current date.}

\item{filename}{Name of the output file to be saved. The default is to create
a file entitled \strong{cumulative_discovery_}.}

\item{format}{A character vector related to the file format of the graph
to be saved. The default is "pdf" to save the output in Portable Document
Format (.pdf), but you can also choose "jpg" to save in Joint Photographic
Experts Group (.jpg), "tiff" to save in Tag Image File Format (.tiff) or
"png" to save in Portable Network Graphics (.png).}
}
\value{
Objects of class c("gg", "ggplot") and saves the output on disk.
}
\description{
Produces graphics of the dynamics of species description and
historical nomenclature changes within any family or genus provided. It is
designed to create graphics based on the dataframe resulted from
\code{powoSpecies}. The graph type can be selected by two arguments
(spp_acc and spp_changes) and then multiple graphs for any different
taxonomic groups within the input data can be produced automatically in a
single run.
}
\examples{
\dontrun{

library(expowo)

accGraph(inputdf = "output",
         verbose = TRUE,
         spp_acc = TRUE,
         spp_changes = TRUE,
         spp_changes_col = "genus",
         genus_plots = TRUE,
         save = FALSE,
         dir = "results_accGraph",
         filename = "cumulative_discovery_Cyperaceae",
         format = "pdf")
}

}
\seealso{
\code{\link{megaGen}}

\code{\link{topGen}}

\code{\link{powoSpecies}}

\code{\link{powoFam}}

\code{\link{powoGenera}}

\code{\link{powoMap}}
}
\author{
Debora Zuanny & Domingos Cardoso
}
