% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic.razon.varianzas.R
\name{ic.razon.varianzas}
\alias{ic.razon.varianzas}
\title{Intervalo confianza para la razón (cociente) de varianzas.}
\usage{
ic.razon.varianzas(
  x,
  variable = NULL,
  introducir = FALSE,
  media_pob = c("desconocida", "conocida"),
  confianza = 0.95,
  grafico = FALSE
)
}
\arguments{
\item{x}{Conjunto de datos. Puede ser un vector o un dataframe.}

\item{variable}{Es un vector (numérico o carácter) que indica las variables a seleccionar de \code{x}. Si \code{x} se refiere a dos variables, \code{variable = NULL}. En caso contrario, es necesario indicar el nombre o posición (número de columna) de las variables.}

\item{introducir}{Valor lógico. Si \code{introducir = FALSE} (por defecto), el usuario debe indicar el conjunto de datos que desea analizar usando los argumentos \code{x} y/o \code{variable}. Si \code{introducir = TRUE}, se le solicitará al ususario que introduzca la información relevante sobre tamaño muestral, valor de la media muestral, etc.}

\item{media_pob}{Es un carácter. Por defecto se supone que la media poblacional es desconocida (\code{media_pob="desconocida"})}

\item{confianza}{Es un valor numérico entre 0 y 1. Indica el nivel de confianza. Por defecto, \code{confianza = 0.95} (95 por ciento)}

\item{grafico}{Es un valor lógico. Por defecto \code{grafico = FALSE}. Si se quiere obtener una representación gráfica del intervalo de confianza obtenido, cambiar el argumento a \code{grafico = TRUE}. Nota: Esta opción no está implementada para todos los casos.}
}
\value{
Devuelve el intervalo del cociente de varianzas poblacionales en un objeto de tipo \code{data.frame}. Si \code{grafico = T} devuelve una \code{list} con el intervalo de confianza y su representación gráfica.
}
\description{
Calcula el intervalo de confianza para la razón (o cociente) de varianzas.

Lee el código QR para video-tutorial sobre el uso de la función con un ejemplo.

\if{html}{\figure{qricrazonvarianzas.png}{width = 200px}}
\if{latex}{\figure{qricrazonvarianzas.png}{options: width=3cm}}
}
\details{
Esta función calcula el intervalo de confianza para el cociente entre la varianza poblacional de la muestra 1 y la de la muestra 2, es decir:

\if{html}{\figure{iccocientevar.png}{width = 80px}}
\if{latex}{\figure{iccocientevar.png}{options: width=1cm}}

Para obtener los intervalos de confianza se opera sobre el estadístico F que se facilita en la nota y que se utiliza para obtener el intervalo del cociente de la varianza de la muestra 2 y la muestra 1.

Los intervalos se obtienen bajo el supuesto de que la media poblacional es desconocida:

(1) si se trabaja con las varianzas muestrales

\if{html}{\figure{iccocientevarmuestra.png}{width = 880px}}
\if{latex}{\figure{iccocientevarmuestra.png}{options: width=14cm}}

(2) si se trabaja con las cuasi-varianzas muestrales

\if{html}{\figure{iccocientevarcuasi.png}{width = 640px}}
\if{latex}{\figure{iccocientevarcuasi.png}{options: width=14cm}}
}
\note{
En el caso de querer deducir el intervalo recíproco, es decir:

\if{html}{\figure{iccocientevar2.png}{width = 80px}}
\if{latex}{\figure{iccocientevar2.png}{options: width=1cm}}

se parte del estadístico:

\if{html}{\figure{Frazonvar.png}{width = 400px}}
\if{latex}{\figure{Frazonvar.png}{options: width=8cm}}

(3) si se trabaja con las varianzas muestrales

\if{html}{\figure{iccocientevarmuestra2.png}{width = 880px}}
\if{latex}{\figure{iccocientevarmuestra2.png}{options: width=14cm}}

(4) si se trabaja con las cuasi-varianzas muestrales

\if{html}{\figure{iccocientevarcuasi2.png}{width = 640px}}
\if{latex}{\figure{iccocientevarcuasi2.png}{options: width=13cm}}
}
\references{
Casas José M. (1997) Inferencia estadística. Editorial: Centro de estudios Ramón Areces, S.A. ISBN: 848004263-X

Esteban García, J. et al. (2008). Curso básico de inferencia estadística. ReproExprés, SL. ISBN: 8493036595.

Murgui, J.S. y otros. (2002). Ejercicios de estadística Economía y Ciencias sociales. tirant lo blanch. ISBN: 9788484424673

Newbold, P, Carlson, W. y Thorne, B. (2019). Statistics for Business and Economics, Global Edition. Pearson. ISBN: 9781292315034
}
\author{
\strong{Vicente Coll-Serrano}.
\emph{Métodos Cuantitativos para la Medición de la Cultura (MC2). Economía Aplicada.}

\strong{Rosario Martínez Verdú}.
\emph{Economía Aplicada.}

Facultad de Economía. Universidad de Valencia (España)
}
